//////////////////
// Card Details //
//////////////////

#include "Card Details.h"
#include "Library.h"
#include "Drawing.h"

CardDetails::CardDetails ()
{
    Card = 0;
}

void CardDetails::Create (const RECT& rect, HWND parent, ViewItem *view)
{
    View = view;
    epp_Frame::Create (0, NULL, WS_CHILD | WS_DLGFRAME | WS_VISIBLE, rect, parent);
}

CardDetails& CardDetails::operator= (int key)
{
    Card = key;
    InvalidateRect ();
    return *this;
}

int CardDetails::OnCreate (CREATESTRUCT *)
{
	ContextMenu.LoadMenu(IDR_CARDPOP);
	return 0;
}

BOOL CardDetails::OnEraseBkgnd (HDC hdc)
{
    static epp_Brush Brush;
    epp_Context dc;
    RECT rect;

    if (!Brush)
        Brush.CreateSolidBrush (GetSysColor (COLOR_WINDOW));

    dc.Attach (hdc);
    GetClientRect (&rect);
    rect.right ++;
    rect.bottom ++;
    dc.FillRect (&rect, Brush);

    return TRUE;
}

void CardDetails::OnLButtonDblClk (int, int, int)
{
    ::PostMessage (GetParent (), WM_LBUTTONDBLCLK, 0, 0);
}

void CardDetails::OnLButtonDown (int, int, int)
{
    Ticker = 0;
}

void CardDetails::OnLButtonUp (int, int, int)
{
    Ticker = 0;
}

void CardDetails::OnMouseMove (int keys, int, int)
{
    if (View && (keys & MK_LBUTTON) && (++Ticker == 2))
        View->StartDrag (*this);
}

void CardDetails::OnPaint ()
{
    epp_PaintContext dc;
    CARD_INFO card;
    RECT rect;

    if (Card) {
        dc.BeginPaint (*this);
        GetClientRect (&rect);
        Library.Find (Card, card);
        DrawCardDetails (dc, rect, card);
    } else
        Forward ();
}

void CardDetails::OnRButtonDown (int, int x, int y)
{
    POINT point = {x, y};
    ClientToScreen (&point);
    ContextMenu.TrackPopupMenu (0, point.x, point.y, GetParent (), NULL, 0);
}

void CardDetails::OnSize (int, int, int)
{
    InvalidateRect ();
}

BEGIN_HANDLER (CardDetails, epp_Frame)
    ON_WM_PAINT
    ON_WM_ERASEBKGND
    ON_WM_MOUSEMOVE
    ON_WM_LBUTTONDOWN
    ON_WM_LBUTTONUP
    ON_WM_LBUTTONDBLCLK
    ON_WM_RBUTTONDOWN
    ON_WM_SIZE
    ON_WM_CREATE
END_HANDLER